/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import me.desht.pneumaticcraft.api.item.ILaunchBehaviour;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.projectile.TumblingBlockEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class ItemLaunching {
    private static final List<ILaunchBehaviour> behaviours = new CopyOnWriteArrayList<ILaunchBehaviour>();

    public static void launchEntity(Entity launchedEntity, Vec3 initialPos, Vec3 velocity, boolean doSpawn) {
        Level world = launchedEntity.m_20193_();
        if (launchedEntity.m_20202_() != null) {
            launchedEntity.m_8127_();
        }
        BlockPos trackPos = new BlockPos(initialPos);
        launchedEntity.m_6034_(initialPos.f_82479_, initialPos.f_82480_, initialPos.f_82481_);
        NetworkHandler.sendToAllTracking(new PacketSetEntityMotion(launchedEntity, velocity), world, trackPos);
        if (launchedEntity instanceof Fireball) {
            Fireball fireball = (Fireball)launchedEntity;
            fireball.f_36813_ = velocity.f_82479_ * 0.05;
            fireball.f_36814_ = velocity.f_82480_ * 0.05;
            fireball.f_36815_ = velocity.f_82481_ * 0.05;
        } else {
            launchedEntity.m_20256_(velocity);
        }
        launchedEntity.m_6853_(false);
        launchedEntity.f_19862_ = false;
        launchedEntity.f_19863_ = false;
        if (doSpawn && !world.f_46443_) {
            world.m_7967_(launchedEntity);
        }
        for (int i = 0; i < 5; ++i) {
            double velX = velocity.f_82479_ * 0.4 + (world.f_46441_.nextGaussian() - 0.5) * 0.05;
            double velY = velocity.f_82480_ * 0.4 + (world.f_46441_.nextGaussian() - 0.5) * 0.05;
            double velZ = velocity.f_82481_ * 0.4 + (world.f_46441_.nextGaussian() - 0.5) * 0.05;
            NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, initialPos.f_82479_, initialPos.f_82480_, initialPos.f_82481_, velX, velY, velZ), world, trackPos);
        }
        world.m_6263_(null, initialPos.f_82479_, initialPos.f_82480_, initialPos.f_82481_, (SoundEvent)ModSounds.AIR_CANNON.get(), SoundSource.BLOCKS, 1.0f, world.f_46441_.nextFloat() / 4.0f + 0.75f);
    }

    public static Entity getEntityToLaunch(Level world, ItemStack stack, Player player, boolean dispenserLike, boolean fallingBlocks) {
        Item item = stack.m_41720_();
        if (dispenserLike) {
            for (ILaunchBehaviour behaviour : behaviours) {
                Entity e = behaviour.getEntityToLaunch(stack, player);
                if (e == null) continue;
                return e;
            }
        }
        if (fallingBlocks && item instanceof BlockItem) {
            return new TumblingBlockEntity(world, (LivingEntity)player, 0.0, 0.0, 0.0, stack);
        }
        ItemEntity e = new ItemEntity(world, 0.0, 0.0, 0.0, stack);
        e.m_32010_(20);
        return e;
    }

    public static void registerBehaviour(ILaunchBehaviour behaviour) {
        behaviours.add(behaviour);
    }

    public static void registerDefaultBehaviours() {
        ItemLaunching.registerBehaviour((stack, player) -> {
            Item item = stack.m_41720_();
            Level level = player.m_183503_();
            if (item == Blocks.f_50077_.m_5456_()) {
                PrimedTnt tnt = new PrimedTnt(level, 0.0, 0.0, 0.0, (LivingEntity)player);
                tnt.m_32085_(80);
                return tnt;
            }
            if (item == Items.f_42612_) {
                return new ThrownExperienceBottle(level, (LivingEntity)player);
            }
            if (item instanceof PotionItem) {
                ThrownPotion potionEntity = new ThrownPotion(level, (LivingEntity)player);
                potionEntity.m_37446_(stack);
                return potionEntity;
            }
            if (item instanceof ArrowItem) {
                return ((ArrowItem)item).m_6394_(level, stack, (LivingEntity)player);
            }
            if (item == Items.f_42521_) {
                return new ThrownEgg(level, (LivingEntity)player);
            }
            if (item == Items.f_42613_) {
                SmallFireball e = new SmallFireball(level, (LivingEntity)player, 0.0, 0.0, 0.0);
                e.m_37010_(stack);
                return e;
            }
            if (item == Items.f_42452_) {
                return new Snowball(level, (LivingEntity)player);
            }
            if (item instanceof SpawnEggItem && level instanceof ServerLevel) {
                EntityType type = ((SpawnEggItem)item).m_43228_(stack.m_41783_());
                Entity e = type.m_20592_((ServerLevel)level, stack, player, player.m_142538_(), MobSpawnType.SPAWN_EGG, false, false);
                if (e instanceof LivingEntity && stack.m_41788_()) {
                    e.m_6593_(stack.m_41786_());
                }
                return e;
            }
            if (item instanceof MinecartItem) {
                return Minecart.m_38119_((Level)level, (double)0.0, (double)0.0, (double)0.0, (AbstractMinecart.Type)((MinecartItem)item).f_42935_);
            }
            if (item instanceof BoatItem) {
                return new Boat(level, 0.0, 0.0, 0.0);
            }
            if (item == Items.f_42688_) {
                return new FireworkRocketEntity(level, 0.0, 0.0, 0.0, stack);
            }
            return null;
        });
    }
}

